<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('localities', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('streets', function(Blueprint $table) {
			$table->foreign('locality_id')->references('id')->on('localities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('tenants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->foreign('procedure_id')->references('id')->on('procedures')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->foreign('payment_id')->references('id')->on('payments')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->foreign('consumption_unit_id')->references('id')->on('consumption_units')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->foreign('message_id')->references('id')->on('messages')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('procedure_id')->references('id')->on('procedures')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('status', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consumption_units', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('consumption_unit_id')->references('id')->on('consumption_units')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('meters', function(Blueprint $table) {
			$table->foreign('consumption_unit_id')->references('id')->on('consumption_units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customer_consumption_unit', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customer_consumption_unit', function(Blueprint $table) {
			$table->foreign('consumption_unit_id')->references('id')->on('consumption_units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('meter_counts', function(Blueprint $table) {
			$table->foreign('meter_id')->references('id')->on('meters')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('meter_counts', function(Blueprint $table) {
			$table->foreign('submitted_user_id')->references('id')->on('tenants')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('localities', function(Blueprint $table) {
			$table->dropForeign('localities_tenant_id_foreign');
		});
		Schema::table('streets', function(Blueprint $table) {
			$table->dropForeign('streets_locality_id_foreign');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->dropForeign('procedures_tenant_id_foreign');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->dropForeign('procedures_user_id_foreign');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->dropForeign('procedures_customer_id_foreign');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->dropForeign('procedures_status_id_foreign');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->dropForeign('postbox_customer_id_foreign');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->dropForeign('postbox_procedure_id_foreign');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->dropForeign('postbox_payment_id_foreign');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->dropForeign('postbox_consumption_unit_id_foreign');
		});
		Schema::table('postbox', function(Blueprint $table) {
			$table->dropForeign('postbox_message_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_tenant_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_procedure_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_tenant_id_foreign');
		});
		Schema::table('status', function(Blueprint $table) {
			$table->dropForeign('status_tenant_id_foreign');
		});
		Schema::table('consumption_units', function(Blueprint $table) {
			$table->dropForeign('consumption_units_tenant_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_tenant_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_customer_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_consumption_unit_id_foreign');
		});
		Schema::table('meters', function(Blueprint $table) {
			$table->dropForeign('meters_consumption_unit_id_foreign');
		});
		Schema::table('customer_consumption_unit', function(Blueprint $table) {
			$table->dropForeign('customer_consumption_unit_customer_id_foreign');
		});
		Schema::table('customer_consumption_unit', function(Blueprint $table) {
			$table->dropForeign('customer_consumption_unit_consumption_unit_id_foreign');
		});
		Schema::table('meter_counts', function(Blueprint $table) {
			$table->dropForeign('meter_counts_meter_id_foreign');
		});
		Schema::table('meter_counts', function(Blueprint $table) {
			$table->dropForeign('meter_counts_submitted_user_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_tenant_id_foreign');
		});
	}
}