<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientesTable extends Migration {

	public function up()
	{
		Schema::create('clientes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombres', 100);
			$table->string('apellidos', 100);
			$table->string('email', 100)->unique();
			$table->string('celular', 50);
			$table->string('telefono', 50)->nullable();
			$table->datetime('fecha_nacimiento');
			$table->integer('id_pais')->unsigned();
			$table->string('nombres_apellidos_conyuge', 100)->nullable();
			$table->datetime('fecha_nacimiento_conyuge')->nullable();
			$table->integer('pais_id_conyuge')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('clientes');
	}
}