<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropiedadesTable extends Migration {

	public function up()
	{
		Schema::create('propiedades', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_factfind')->unsigned();
			$table->string('existente_hipoteca', 50)->nullable();
			$table->integer('plazo')->nullable()->default('0');
			$table->decimal('valor', 8,2)->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('propiedades');
	}
}