<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchCoefficientsTable extends Migration {

	public function up()
	{
		Schema::create('match_coefficients', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('match_id')->unsigned()->nullable()->index();
			$table->integer('bookmaker_id')->unsigned()->nullable();
			$table->float('1')->nullable();
			$table->float('x')->nullable();
			$table->float('2')->nullable();
			$table->float('1x')->nullable();
			$table->float('x2')->nullable();
			$table->float('over_25')->nullable();
			$table->float('under_25')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('match_coefficients');
	}
}