<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTournamentsTable extends Migration {

	public function up()
	{
		Schema::create('tournaments', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable()->index();
			$table->string('slug')->unique();
			$table->integer('year_foundation')->nullable()->index();
			$table->integer('country_id')->nullable()->index();
			$table->integer('popular')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('tournaments');
	}
}