<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGalleriesTable extends Migration {

	public function up()
	{
		Schema::create('galleries', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('name')->nullable();
			$table->string('url')->nullable();
			$table->char('type_media', 6)->nullable();
			$table->integer('entity_id');
			$table->string('entity_type');
			$table->timestamps();
			$table->integer('viewed')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('galleries');
	}
}