<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTournamentRefereesTable extends Migration {

	public function up()
	{
		Schema::create('tournament_referees', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('season_id')->unsigned()->index();
			$table->integer('tournament_id')->unsigned()->index();
			$table->integer('tournament_season_id')->unsigned()->index();
			$table->integer('referee_id')->primary()->unsigned()->index();
			$table->integer('games')->nullable();
			$table->integer('yc')->nullable();
			$table->integer('2yc')->nullable();
			$table->integer('rc')->unsigned()->nullable();
			$table->integer('penalty')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tournament_referees');
	}
}