<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchStatisticsTable extends Migration {

	public function up()
	{
		Schema::create('match_statistics', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('match_id')->primary()->unsigned()->index();
			$table->smallInteger('attacks')->nullable();
			$table->smallInteger('dangerous_attacks')->nullable();
			$table->smallInteger('shots_on_goal')->nullable();
			$table->smallInteger('shots_on_target')->nullable();
			$table->smallInteger('shot_on_rod')->nullable();
			$table->smallInteger('fouls')->nullable();
			$table->smallInteger('corner')->nullable();
			$table->smallInteger('offside')->nullable();
			$table->smallInteger('possession')->nullable();
			$table->smallInteger('blocked_kicks')->nullable();
			$table->smallInteger('penalty_kicks')->nullable();
			$table->smallInteger('goal_kick')->nullable();
			$table->smallInteger('outs')->nullable();
			$table->smallInteger('yc')->nullable();
			$table->smallInteger('rc')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('match_statistics');
	}
}