<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayersTable extends Migration {

	public function up()
	{
		Schema::create('players', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('slug')->unique()->nullable();
			$table->text('about')->nullable();
			$table->text('career');
			$table->string('img')->nullable();
			$table->date('birthday')->nullable();
			$table->smallInteger('growth')->nullable();
			$table->smallInteger('weight')->nullable();
			$table->string('instagram')->nullable();
			$table->string('wikipedia')->nullable();
			$table->string('facebook')->nullable();
			$table->string('twitter')->nullable();
			$table->string('site')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('players');
	}
}