<?php

class Stadium extends Eloquent {

	protected $table = 'stadiums';
	public $timestamps = false;
	protected $fillable = array('name', 'slug', 'img', 'city_id', 'capacity', 'content');

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function teamSeasons()
	{
		return $this->hasMany('TeamSeason');
	}

	public function matches()
	{
		return $this->hasMany('Match');
	}

	public function tournaments()
	{
		return $this->belongsToMany('Tournament');
	}

	public function galleries()
	{
		return $this->morphMany('Gallery', 'entity');
	}

}