<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Bookmaker extends Model 
{

    protected $table = 'bookmakers';
    public $timestamps = true;
    protected $fillable = array('name', 'slug', 'meta_title', 'meta_description', 'meta_keyword', 'img', 'reg_date', 'bonus', 'bonus_currency', 'rating', 'google_play', 'app_store', 'site', 'phone', 'email', 'live_chat');

    public function faqs()
    {
        return $this->hasMany('BookmakerFaq');
    }

    public function description()
    {
        return $this->hasOne('BookmakerDescription');
    }

    public function coefficients()
    {
        return $this->hasMany('MatchCoefficient');
    }

    public function reviews()
    {
        return $this->hasMany('BookmakerReview');
    }

}