<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Referee extends Model 
{

    protected $table = 'referees';
    public $timestamps = false;
    protected $fillable = array('name', 'slug', 'img', 'city_id', 'birthday');

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function nationalities()
    {
        return $this->morphToMany('Country', 'nationality');
    }

    public function matches()
    {
        return $this->hasMany('Match');
    }

    public function galleries()
    {
        return $this->morphMany('Gallery', 'entity');
    }

}