<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_seasons', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_seasons', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_seasons', function(Blueprint $table) {
			$table->foreign('lwinter_tid')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_seasons', function(Blueprint $table) {
			$table->foreign('winter_team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('tournament_season_id')->references('id')->on('tournament_seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('tournament_round_id')->references('id')->on('tournament_raunds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('tournament_group_id')->references('id')->on('tournament_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('team_home_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('team_away_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('stadium_id')->references('id')->on('stadiums')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->foreign('referee_id')->references('id')->on('referees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('referees', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stadiums', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->foreign('stadium_id')->references('id')->on('stadiums')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->foreign('coach_id')->references('id')->on('coaches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_goals', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('matches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_goals', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_cards', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('matches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_cards', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_plaers', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_plaers', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_statistics', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('matches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_stadiums', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_stadiums', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_stadiums', function(Blueprint $table) {
			$table->foreign('tournament_season_id')->references('id')->on('tournament_seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_stadiums', function(Blueprint $table) {
			$table->foreign('stadium_id')->references('id')->on('stadiums')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_coaches', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_coaches', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_coaches', function(Blueprint $table) {
			$table->foreign('tournament_season_id')->references('id')->on('tournament_seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_coaches', function(Blueprint $table) {
			$table->foreign('coach_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_referees', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_referees', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_referees', function(Blueprint $table) {
			$table->foreign('tournament_season_id')->references('id')->on('tournament_seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_referees', function(Blueprint $table) {
			$table->foreign('referee_id')->references('id')->on('referees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->foreign('tournament_season_id')->references('id')->on('tournament_seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->foreign('amplua_id')->references('id')->on('ampluas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->foreign('tournament_season_id')->references('id')->on('tournament_seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->foreign('tournament_round_id')->references('id')->on('tournament_raunds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->foreign('tournament_group_id')->references('id')->on('tournament_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_passes', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('matches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_passes', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_table_performances', function(Blueprint $table) {
			$table->foreign('tournament_table_id')->references('id')->on('tournament_tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_table_performances', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('matches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('galleries', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('player_statistics', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_rating_uefa', function(Blueprint $table) {
			$table->foreign('season_id')->references('id')->on('seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('team_rating_uefa', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookmaker_faqs', function(Blueprint $table) {
			$table->foreign('bookmaker_id')->references('id')->on('bookmakers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookmaker_descriptions', function(Blueprint $table) {
			$table->foreign('bookmaker_id')->references('id')->on('bookmakers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_coefficients', function(Blueprint $table) {
			$table->foreign('match_id')->references('id')->on('matches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('match_coefficients', function(Blueprint $table) {
			$table->foreign('bookmaker_id')->references('id')->on('bookmakers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookmaker_reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookmaker_reviews', function(Blueprint $table) {
			$table->foreign('bookmaker_id')->references('id')->on('bookmakers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_user_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_user_id_foreign');
		});
		Schema::table('tournament_seasons', function(Blueprint $table) {
			$table->dropForeign('tournament_seasons_season_id_foreign');
		});
		Schema::table('tournament_seasons', function(Blueprint $table) {
			$table->dropForeign('tournament_seasons_tournament_id_foreign');
		});
		Schema::table('tournament_seasons', function(Blueprint $table) {
			$table->dropForeign('tournament_seasons_lwinter_tid_foreign');
		});
		Schema::table('tournament_seasons', function(Blueprint $table) {
			$table->dropForeign('tournament_seasons_winter_team_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_country_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_city_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_season_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_tournament_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_tournament_season_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_tournament_round_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_tournament_group_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_team_home_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_team_away_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_stadium_id_foreign');
		});
		Schema::table('matches', function(Blueprint $table) {
			$table->dropForeign('matches_referee_id_foreign');
		});
		Schema::table('referees', function(Blueprint $table) {
			$table->dropForeign('referees_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('stadiums', function(Blueprint $table) {
			$table->dropForeign('stadiums_city_id_foreign');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->dropForeign('team_sesons_season_id_foreign');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->dropForeign('team_sesons_tournament_id_foreign');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->dropForeign('team_sesons_team_id_foreign');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->dropForeign('team_sesons_stadium_id_foreign');
		});
		Schema::table('team_sesons', function(Blueprint $table) {
			$table->dropForeign('team_sesons_coach_id_foreign');
		});
		Schema::table('match_goals', function(Blueprint $table) {
			$table->dropForeign('match_goals_match_id_foreign');
		});
		Schema::table('match_goals', function(Blueprint $table) {
			$table->dropForeign('match_goals_player_id_foreign');
		});
		Schema::table('match_cards', function(Blueprint $table) {
			$table->dropForeign('match_cards_match_id_foreign');
		});
		Schema::table('match_cards', function(Blueprint $table) {
			$table->dropForeign('match_cards_player_id_foreign');
		});
		Schema::table('match_plaers', function(Blueprint $table) {
			$table->dropForeign('match_plaers_match_id_foreign');
		});
		Schema::table('match_plaers', function(Blueprint $table) {
			$table->dropForeign('match_plaers_player_id_foreign');
		});
		Schema::table('match_statistics', function(Blueprint $table) {
			$table->dropForeign('match_statistics_match_id_foreign');
		});
		Schema::table('tournament_stadiums', function(Blueprint $table) {
			$table->dropForeign('tournament_stadiums_season_id_foreign');
		});
		Schema::table('tournament_stadiums', function(Blueprint $table) {
			$table->dropForeign('tournament_stadiums_tournament_id_foreign');
		});
		Schema::table('tournament_stadiums', function(Blueprint $table) {
			$table->dropForeign('tournament_stadiums_tournament_season_id_foreign');
		});
		Schema::table('tournament_stadiums', function(Blueprint $table) {
			$table->dropForeign('tournament_stadiums_stadium_id_foreign');
		});
		Schema::table('tournament_coaches', function(Blueprint $table) {
			$table->dropForeign('tournament_coaches_season_id_foreign');
		});
		Schema::table('tournament_coaches', function(Blueprint $table) {
			$table->dropForeign('tournament_coaches_tournament_id_foreign');
		});
		Schema::table('tournament_coaches', function(Blueprint $table) {
			$table->dropForeign('tournament_coaches_tournament_season_id_foreign');
		});
		Schema::table('tournament_coaches', function(Blueprint $table) {
			$table->dropForeign('tournament_coaches_coach_id_foreign');
		});
		Schema::table('tournament_referees', function(Blueprint $table) {
			$table->dropForeign('tournament_referees_season_id_foreign');
		});
		Schema::table('tournament_referees', function(Blueprint $table) {
			$table->dropForeign('tournament_referees_tournament_id_foreign');
		});
		Schema::table('tournament_referees', function(Blueprint $table) {
			$table->dropForeign('tournament_referees_tournament_season_id_foreign');
		});
		Schema::table('tournament_referees', function(Blueprint $table) {
			$table->dropForeign('tournament_referees_referee_id_foreign');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->dropForeign('tournament_players_season_id_foreign');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->dropForeign('tournament_players_tournament_id_foreign');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->dropForeign('tournament_players_tournament_season_id_foreign');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->dropForeign('tournament_players_team_id_foreign');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->dropForeign('tournament_players_player_id_foreign');
		});
		Schema::table('tournament_players', function(Blueprint $table) {
			$table->dropForeign('tournament_players_amplua_id_foreign');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->dropForeign('tournament_tables_season_id_foreign');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->dropForeign('tournament_tables_tournament_id_foreign');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->dropForeign('tournament_tables_tournament_season_id_foreign');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->dropForeign('tournament_tables_tournament_round_id_foreign');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->dropForeign('tournament_tables_tournament_group_id_foreign');
		});
		Schema::table('tournament_tables', function(Blueprint $table) {
			$table->dropForeign('tournament_tables_team_id_foreign');
		});
		Schema::table('tournament_passes', function(Blueprint $table) {
			$table->dropForeign('tournament_passes_match_id_foreign');
		});
		Schema::table('tournament_passes', function(Blueprint $table) {
			$table->dropForeign('tournament_passes_player_id_foreign');
		});
		Schema::table('tournament_table_performances', function(Blueprint $table) {
			$table->dropForeign('tournament_table_performances_tournament_table_id_foreign');
		});
		Schema::table('tournament_table_performances', function(Blueprint $table) {
			$table->dropForeign('tournament_table_performances_match_id_foreign');
		});
		Schema::table('galleries', function(Blueprint $table) {
			$table->dropForeign('galleries_user_id_foreign');
		});
		Schema::table('player_statistics', function(Blueprint $table) {
			$table->dropForeign('player_statistics_player_id_foreign');
		});
		Schema::table('team_rating_uefa', function(Blueprint $table) {
			$table->dropForeign('team_rating_uefa_season_id_foreign');
		});
		Schema::table('team_rating_uefa', function(Blueprint $table) {
			$table->dropForeign('team_rating_uefa_team_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('bookmaker_faqs', function(Blueprint $table) {
			$table->dropForeign('bookmaker_faqs_bookmaker_id_foreign');
		});
		Schema::table('bookmaker_descriptions', function(Blueprint $table) {
			$table->dropForeign('bookmaker_descriptions_bookmaker_id_foreign');
		});
		Schema::table('match_coefficients', function(Blueprint $table) {
			$table->dropForeign('match_coefficients_match_id_foreign');
		});
		Schema::table('match_coefficients', function(Blueprint $table) {
			$table->dropForeign('match_coefficients_bookmaker_id_foreign');
		});
		Schema::table('bookmaker_reviews', function(Blueprint $table) {
			$table->dropForeign('bookmaker_reviews_user_id_foreign');
		});
		Schema::table('bookmaker_reviews', function(Blueprint $table) {
			$table->dropForeign('bookmaker_reviews_bookmaker_id_foreign');
		});
	}
}