<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookmakerDescriptionsTable extends Migration {

	public function up()
	{
		Schema::create('bookmaker_descriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('bookmaker_id')->unsigned()->nullable()->index();
			$table->text('about')->nullable();
			$table->text('plus')->nullable();
			$table->text('minuses')->nullable();
			$table->text('specifications')->nullable();
			$table->float('storage')->nullable();
			$table->float('line_prematch')->nullable();
			$table->float('line_life')->nullable();
			$table->float('coefficients')->nullable();
			$table->float('convenience')->nullable();
			$table->float('support')->nullable();
			$table->float('bonuses')->nullable();
			$table->float('manufacturability')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bookmaker_descriptions');
	}
}