<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookmakersTable extends Migration {

	public function up()
	{
		Schema::create('bookmakers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('name')->index();
			$table->string('slug')->unique()->nullable();
			$table->string('meta_title')->nullable();
			$table->string('meta_description')->nullable();
			$table->string('meta_keyword')->nullable();
			$table->string('img')->nullable();
			$table->date('reg_date')->nullable();
			$table->integer('bonus')->nullable();
			$table->char('bonus_currency')->nullable();
			$table->integer('rating')->nullable();
			$table->string('google_play')->nullable();
			$table->string('app_store')->nullable();
			$table->string('site')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->string('live_chat')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bookmakers');
	}
}