<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchesTable extends Migration {

	public function up()
	{
		Schema::create('matches', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('season_id')->primary()->unsigned()->index();
			$table->integer('tournament_id')->primary()->unsigned()->index();
			$table->integer('tournament_season_id')->primary()->unsigned()->index();
			$table->integer('tournament_round_id')->unsigned()->nullable();
			$table->integer('tournament_group_id')->unsigned()->nullable();
			$table->smallInteger('tour')->nullable();
			$table->date('play_date')->nullable();
			$table->time('play_time')->nullable();
			$table->bigInteger('team_home_id')->primary()->unsigned()->index();
			$table->bigInteger('team_away_id')->primary()->unsigned()->index();
			$table->smallInteger('result_1')->nullable();
			$table->smallInteger('result_2')->nullable();
			$table->string('result_extra_time')->nullable();
			$table->smallInteger('result_match')->nullable();
			$table->integer('viewed')->nullable();
			$table->integer('stadium_id')->unsigned()->nullable();
			$table->integer('referee_id')->unsigned()->nullable();
			$table->text('description')->nullable();
			$table->smallInteger('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('matches');
	}
}