<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStadiumsTable extends Migration {

	public function up()
	{
		Schema::create('stadiums', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('slug')->unique()->nullable();
			$table->string('img')->nullable();
			$table->integer('city_id')->unsigned()->nullable()->index();
			$table->integer('capacity')->nullable();
			$table->text('content')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stadiums');
	}
}