<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTournamentSeasonsTable extends Migration {

	public function up()
	{
		Schema::create('tournament_seasons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('season_id')->unsigned()->index();
			$table->integer('tournament_id')->primary()->unsigned()->index();
			$table->date('date_start')->nullable();
			$table->string('date_finish')->nullable();
			$table->bigInteger('lwinter_tid')->unsigned()->nullable();
			$table->bigInteger('winter_team_id')->unsigned()->nullable();
			$table->tinyInteger('status')->index()->default('0');
			$table->integer('total_game')->nullable();
			$table->integer('played_game')->nullable();
			$table->integer('home_wins')->nullable();
			$table->integer('draws')->nullable();
			$table->string('guest_wins')->nullable();
			$table->integer('total_goals')->nullable();
			$table->integer('home_goals')->nullable();
			$table->integer('quest_goals')->nullable();
			$table->integer('viewers')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tournament_seasons');
	}
}