<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->index();
			$table->string('name')->index();
			$table->string('slug')->unique()->nullable();
			$table->text('excerpt')->nullable();
			$table->text('content')->nullable();
			$table->string('meta_title')->nullable();
			$table->string('meta_description')->nullable();
			$table->string('meta_keywords')->nullable();
			$table->enum('status', array('publish', 'future', 'draft', 'pending', 'trash'))->nullable()->index();
			$table->string('post_type')->nullable()->index();
			$table->integer('viewed')->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}