<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->index();
			$table->string('slug')->unique();
			$table->string('img')->nullable();
			$table->date('foundation_year')->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('instagram')->nullable();
			$table->string('wikipedia')->nullable();
			$table->string('facebook')->nullable();
			$table->string('twitter')->nullable();
			$table->string('site')->nullable();
			$table->enum('type', array('club', 'nt'));
			$table->timestamp('timestamps');
			$table->text('about');
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}