<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLigneDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('ligne_documents', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->integer('id_document')->unsigned();
			$table->integer('code_agence')->unsigned();
			$table->integer('id_ligne');
			$table->integer('code_produit')->unsigned();
			$table->string('quantite');
			$table->string('code_catalogue');
			$table->string('designation');
			$table->decimal('prix_brut');
			$table->string('remise1');
			$table->string('remise2');
			$table->string('remise3');
			$table->string('remise4');
			$table->decimal('prix_net');
			$table->string('unite');
			$table->decimal('montant_ecotaxe');
			$table->decimal('total_ht');
			$table->decimal('total_tva');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ligne_documents');
	}
}