<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('agences', function(Blueprint $table) {
			$table->foreign('code_dr')->references('code_agence')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('compta_clients', function(Blueprint $table) {
			$table->foreign('numero_agence')->references('code_agence')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('remises_clients', function(Blueprint $table) {
			$table->foreign('code_agence')->references('code_agence')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('remises_clients', function(Blueprint $table) {
			$table->foreign('code_client')->references('code_client')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('remises_clients', function(Blueprint $table) {
			$table->foreign('code_fournisseur')->references('code_fournisseur')->on('fournisseurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('remises_clients', function(Blueprint $table) {
			$table->foreign('code_produit')->references('code_produit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tarifs', function(Blueprint $table) {
			$table->foreign('code_produit')->references('code_produit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tarifs', function(Blueprint $table) {
			$table->foreign('code_fournisseur')->references('code_fournisseur')->on('fournisseurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('agence')->references('code_agence')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('compta_fournisseurs', function(Blueprint $table) {
			$table->foreign('numero_agence')->references('code_agence')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prix_moyens', function(Blueprint $table) {
			$table->foreign('agence')->references('code_agence')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prix_moyens', function(Blueprint $table) {
			$table->foreign('code_produit')->references('code_produit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('livraison_fournisseurs', function(Blueprint $table) {
			$table->foreign('code_fournisseur')->references('code_fournisseur')->on('fournisseurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produits', function(Blueprint $table) {
			$table->foreign('code_fournisseur')->references('code_fournisseur')->on('fournisseurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ligne_documents', function(Blueprint $table) {
			$table->foreign('id_document')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ligne_documents', function(Blueprint $table) {
			$table->foreign('code_agence')->references('code_agence')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ligne_documents', function(Blueprint $table) {
			$table->foreign('code_produit')->references('code_produit')->on('produits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('agences', function(Blueprint $table) {
			$table->dropForeign('agences_code_dr_foreign');
		});
		Schema::table('compta_clients', function(Blueprint $table) {
			$table->dropForeign('compta_clients_numero_agence_foreign');
		});
		Schema::table('remises_clients', function(Blueprint $table) {
			$table->dropForeign('remises_clients_code_agence_foreign');
		});
		Schema::table('remises_clients', function(Blueprint $table) {
			$table->dropForeign('remises_clients_code_client_foreign');
		});
		Schema::table('remises_clients', function(Blueprint $table) {
			$table->dropForeign('remises_clients_code_fournisseur_foreign');
		});
		Schema::table('remises_clients', function(Blueprint $table) {
			$table->dropForeign('remises_clients_code_produit_foreign');
		});
		Schema::table('tarifs', function(Blueprint $table) {
			$table->dropForeign('tarifs_code_produit_foreign');
		});
		Schema::table('tarifs', function(Blueprint $table) {
			$table->dropForeign('tarifs_code_fournisseur_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_agence_foreign');
		});
		Schema::table('compta_fournisseurs', function(Blueprint $table) {
			$table->dropForeign('compta_fournisseurs_numero_agence_foreign');
		});
		Schema::table('prix_moyens', function(Blueprint $table) {
			$table->dropForeign('prix_moyens_agence_foreign');
		});
		Schema::table('prix_moyens', function(Blueprint $table) {
			$table->dropForeign('prix_moyens_code_produit_foreign');
		});
		Schema::table('livraison_fournisseurs', function(Blueprint $table) {
			$table->dropForeign('livraison_fournisseurs_code_fournisseur_foreign');
		});
		Schema::table('produits', function(Blueprint $table) {
			$table->dropForeign('produits_code_fournisseur_foreign');
		});
		Schema::table('ligne_documents', function(Blueprint $table) {
			$table->dropForeign('ligne_documents_id_document_foreign');
		});
		Schema::table('ligne_documents', function(Blueprint $table) {
			$table->dropForeign('ligne_documents_code_agence_foreign');
		});
		Schema::table('ligne_documents', function(Blueprint $table) {
			$table->dropForeign('ligne_documents_code_produit_foreign');
		});
	}
}