<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrivacyTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('privacy_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->text('description');
			$table->string('locale');
			$table->bigInteger('privacy_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('privacy_translations');
	}
}