<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('privacy_translations', function(Blueprint $table) {
			$table->foreign('privacy_id')->references('id')->on('privacy')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('term_translations', function(Blueprint $table) {
			$table->foreign('term_id')->references('id')->on('terms')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('fqs_translations', function(Blueprint $table) {
			$table->foreign('fqs_id')->references('id')->on('fqs')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('currency_translations', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('contact_images', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('cascade')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('privacy_translations', function(Blueprint $table) {
			$table->dropForeign('privacy_translations_privacy_id_foreign');
		});
		Schema::table('term_translations', function(Blueprint $table) {
			$table->dropForeign('term_translations_term_id_foreign');
		});
		Schema::table('fqs_translations', function(Blueprint $table) {
			$table->dropForeign('fqs_translations_fqs_id_foreign');
		});
		Schema::table('currency_translations', function(Blueprint $table) {
			$table->dropForeign('currency_translations_currency_id_foreign');
		});
		Schema::table('contact_images', function(Blueprint $table) {
			$table->dropForeign('contact_images_contact_id_foreign');
		});
	}
}