<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkflowConditionsTable extends Migration {

	public function up()
	{
		Schema::create('workflow_conditions', function(Blueprint $table) {
			$table->uuid('workflowConditionsId', 36)->unique();
			$table->timestamps();
			$table->boolean('required');
			$table->string('name');
			$table->text('uri');
			$table->text('path');
			$table->text('trueAction');
			$table->string('falseAction');
			$table->char('workflowStepsId', 36);
		});
	}

	public function down()
	{
		Schema::drop('workflow_conditions');
	}
}