<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('photos_users', function(Blueprint $table) {
			$table->foreign('photo_id')->references('id')->on('photos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('photos_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('follows', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('follows', function(Blueprint $table) {
			$table->foreign('followed_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('photo_id')->references('id')->on('photos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('subcomments', function(Blueprint $table) {
			$table->foreign('comment_id')->references('id')->on('comments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('public_messages', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('public_messages', function(Blueprint $table) {
			$table->foreign('chat_id')->references('id')->on('public_messages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('private_messages', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('private_messages', function(Blueprint $table) {
			$table->foreign('recipient_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('choices', function(Blueprint $table) {
			$table->foreign('photo_id')->references('id')->on('photos')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('choices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('publications', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('photos_users', function(Blueprint $table) {
			$table->dropForeign('photos_users_photo_id_foreign');
		});
		Schema::table('photos_users', function(Blueprint $table) {
			$table->dropForeign('photos_users_user_id_foreign');
		});
		Schema::table('follows', function(Blueprint $table) {
			$table->dropForeign('follows_follower_id_foreign');
		});
		Schema::table('follows', function(Blueprint $table) {
			$table->dropForeign('follows_followed_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_photo_id_foreign');
		});
		Schema::table('subcomments', function(Blueprint $table) {
			$table->dropForeign('subcomments_comment_id_foreign');
		});
		Schema::table('public_messages', function(Blueprint $table) {
			$table->dropForeign('public_messages_author_id_foreign');
		});
		Schema::table('public_messages', function(Blueprint $table) {
			$table->dropForeign('public_messages_chat_id_foreign');
		});
		Schema::table('private_messages', function(Blueprint $table) {
			$table->dropForeign('private_messages_author_id_foreign');
		});
		Schema::table('private_messages', function(Blueprint $table) {
			$table->dropForeign('private_messages_recipient_id_foreign');
		});
		Schema::table('choices', function(Blueprint $table) {
			$table->dropForeign('choices_photo_id_foreign');
		});
		Schema::table('choices', function(Blueprint $table) {
			$table->dropForeign('choices_user_id_foreign');
		});
		Schema::table('publications', function(Blueprint $table) {
			$table->dropForeign('publications_author_id_foreign');
		});
	}
}