<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseTable extends Migration {

	public function up()
	{
		Schema::create('course', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->timestamps();
			$table->tinyInteger('public');
			$table->string('alias');
			$table->integer('sorting_order');
			$table->datetime('start_date');
			$table->text('short_desc');
			$table->integer('price');
			$table->string('price_before_increase');
			$table->integer('days_before_increase');
			$table->string('project_examples');
			$table->string('end_courses');
			$table->string('title');
			$table->text('meta_description');
			$table->text('meta_keywords');
		});
	}

	public function down()
	{
		Schema::drop('course');
	}
}