<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentTable extends Migration {

	public function up()
	{
		Schema::create('student', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('course_id');
			$table->integer('lesson_id');
			$table->integer('group_id');
			$table->tinyInteger('public');
			$table->string('name', 25);
			$table->string('surname', 45);
			$table->date('birthdate');
			$table->string('city', 25);
			$table->string('company', 25);
			$table->string('photo', 255);
			$table->string('position');
			$table->string('telephone');
			$table->string('skype');
			$table->string('facebook');
			$table->string('vk');
			$table->text('short_desc');
			$table->string('permissions');
			$table->string('course_date');
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('student');
	}
}