<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->integer('source_id')->unsigned()->nullable();
			$table->boolean('is_confirmed')->default(0);
			$table->boolean('is_exported')->default(0);
			$table->datetime('confirmed_at')->nullable();
			$table->datetime('exported_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}