<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('sources')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('article_order', function(Blueprint $table) {
			$table->foreign('article_id')->references('id')->on('articles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('article_order', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_account_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_account_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_source_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_order_id_foreign');
		});
		Schema::table('article_order', function(Blueprint $table) {
			$table->dropForeign('article_order_article_id_foreign');
		});
		Schema::table('article_order', function(Blueprint $table) {
			$table->dropForeign('article_order_order_id_foreign');
		});
	}
}