<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabelValuesTable extends Migration {

	public function up()
	{
		Schema::create('label_values', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned();
			$table->integer('business_id')->unsigned()->index();
			$table->integer('label_id')->unsigned();
			$table->string('value', 255);
			$table->boolean('is_deleted')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('label_values');
	}
}