<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLogsTable extends Migration {

	public function up()
	{
		Schema::create('logs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('account_id')->unsigned();
			$table->longText('description')->nullable();
			$table->string('extra_values', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('logs');
	}
}