<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('phone', 255);
			$table->string('phone_1', 255)->nullable();
			$table->string('address', 255);
			$table->string('address_1', 255)->nullable();
			$table->string('industry', 255);
			$table->string('bank_name', 255)->nullable();
			$table->string('bank_account', 255)->nullable();
			$table->boolean('is_deleted')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}