<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerAddressesTable extends Migration {

	public function up()
	{
		Schema::create('customer_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('address_street', 150);
			$table->string('address_city');
			$table->string('address_state');
			$table->smallInteger('address_pincode');
			$table->string('address_landmark');
			$table->string('address_phone');
			$table->string('address_owner');
			$table->bigInteger('customer_id')->unsigned();
			$table->tinyInteger('default_active')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('customer_addresses');
	}
}