<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Curso extends Model 
{

    protected $table = 'cursos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Nombre', 'Descripcion', 'Foto', 'docente_id', 'habilitado');
    protected $visible = array('Nombre', 'Descripcion', 'Foto', 'docente_id', 'habilitado');

    public function tipoCurso()
    {
        return $this->hasOne('TipoCurso');
    }

    public function docente()
    {
        return $this->hasOne('Docente');
    }

    public function clasescurso()
    {
        return $this->hasMany('Clase');
    }

}