<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Matricula extends Model 
{

    protected $table = 'matriculas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_curso', 'rindioexamen', 'presentotif', 'observaciones', 'habilitado');
    protected $visible = array('id_curso', 'rindioexamen', 'presentotif', 'observaciones', 'habilitado');

    public function alumno()
    {
        return $this->hasOne('Alumno');
    }

    public function curso()
    {
        return $this->hasOne('Curso');
    }

    public function asistencias()
    {
        return $this->hasMany('Asistencia');
    }

}