<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Asistencia extends Model 
{

    protected $table = 'asistencias';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_matricula', 'id_clase', 'asistio');
    protected $visible = array('id_matricula', 'id_clase', 'asistio');

    public function clases()
    {
        return $this->belongsToMany('Clase');
    }

    public function matriculas()
    {
        return $this->hasMany('Matricula');
    }

}