<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Clase extends Model 
{

    protected $table = 'clases';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nombreclase', 'fecha');
    protected $visible = array('nombreclase', 'fecha');

    public function asistencias()
    {
        return $this->hasMany('Asistencia');
    }

    public function curso()
    {
        return $this->belongsTo('Curso');
    }

}