<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Curso extends Eloquent {

	protected $table = 'cursos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Nombre', 'Descripcion', 'Foto', 'docente_id', 'habilitado');
	protected $visible = array('Nombre', 'Descripcion', 'Foto', 'docente_id', 'habilitado');

	public function tipoCurso()
	{
		return $this->hasOne('TipoCurso');
	}

	public function docente()
	{
		return $this->hasOne('Docente');
	}

	public function clasescurso()
	{
		return $this->hasMany('Clase');
	}

}