<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Asistencia extends Eloquent {

	protected $table = 'asistencias';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_matricula', 'id_clase', 'asistio');
	protected $visible = array('id_matricula', 'id_clase', 'asistio');

	public function clases()
	{
		return $this->belongsToMany('Clase');
	}

	public function matriculas()
	{
		return $this->hasMany('Matricula');
	}

}