<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Clase extends Eloquent {

	protected $table = 'clases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nombreclase', 'fecha');
	protected $visible = array('nombreclase', 'fecha');

	public function asistencias()
	{
		return $this->hasMany('Asistencia');
	}

	public function curso()
	{
		return $this->belongsTo('Curso');
	}

}