<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAlumnosTable extends Migration {

	public function up()
	{
		Schema::create('alumnos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nombre');
			$table->string('apellido', 500);
			$table->string('direccion');
			$table->string('foto');
			$table->integer('ciudad_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('alumnos');
	}
}