<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('alumnos', function(Blueprint $table) {
			$table->foreign('ciudad_id')->references('id')->on('ciudades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->foreign('docente_id')->references('id')->on('docentes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->foreign('tipo_curso_id')->references('id')->on('tiposcursos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matriculas', function(Blueprint $table) {
			$table->foreign('id_alumno')->references('id')->on('alumnos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matriculas', function(Blueprint $table) {
			$table->foreign('id_curso')->references('id')->on('cursos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clases', function(Blueprint $table) {
			$table->foreign('id_curso')->references('id')->on('cursos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asistencias', function(Blueprint $table) {
			$table->foreign('id_matricula')->references('id')->on('matriculas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asistencias', function(Blueprint $table) {
			$table->foreign('id_clase')->references('id')->on('clases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('alumnos', function(Blueprint $table) {
			$table->dropForeign('alumnos_ciudad_id_foreign');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->dropForeign('cursos_docente_id_foreign');
		});
		Schema::table('cursos', function(Blueprint $table) {
			$table->dropForeign('cursos_tipo_curso_id_foreign');
		});
		Schema::table('matriculas', function(Blueprint $table) {
			$table->dropForeign('matriculas_id_alumno_foreign');
		});
		Schema::table('matriculas', function(Blueprint $table) {
			$table->dropForeign('matriculas_id_curso_foreign');
		});
		Schema::table('clases', function(Blueprint $table) {
			$table->dropForeign('clases_id_curso_foreign');
		});
		Schema::table('asistencias', function(Blueprint $table) {
			$table->dropForeign('asistencias_id_matricula_foreign');
		});
		Schema::table('asistencias', function(Blueprint $table) {
			$table->dropForeign('asistencias_id_clase_foreign');
		});
	}
}