<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('cat_id')->unsigned();
			$table->tinyInteger('ad_type');
			$table->string('license_number');
			$table->integer('width');
			$table->integer('height');
			$table->bigInteger('price');
			$table->text('discription');
			$table->boolean('is_rent');
			$table->string('map_latitude');
			$table->string('map_longitude');
			$table->string('region');
			$table->string('city');
			$table->string('city_side');
			$table->string('district');
			$table->boolean('video_priority');
			$table->boolean('stared');
			$table->boolean('active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}