<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApartmentsTable extends Migration {

	public function up()
	{
		Schema::create('apartments', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('type');
			$table->string('neighborhood');
			$table->string('map_location');
			$table->tinyInteger('rent_time');
			$table->integer('floor');
			$table->string('building_age');
			$table->integer('living_rooms');
			$table->integer('bedrooms');
			$table->integer('bathrooms');
			$table->string('street_width');
			$table->tinyInteger('furnished');
			$table->tinyInteger('kitchen_availability');
			$table->string('extra_unit_availability')->nullable();
			$table->tinyInteger('water_availability');
			$table->tinyInteger('car_entrance');
			$table->tinyInteger('elevator_availability');
			$table->string('size');
			$table->string('length');
			$table->string('additional_fields');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('apartments');
	}
}