<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->foreign('cat_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('imagable_id')->references('id')->on('ads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('imagable_type')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('videoable_id')->references('id')->on('ads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('videoable_type')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('ads_id')->references('id')->on('ads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('ads_id')->references('id')->on('ads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_user_id_foreign');
		});
		Schema::table('ads', function(Blueprint $table) {
			$table->dropForeign('ads_cat_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_imagable_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_imagable_type_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_videoable_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_videoable_type_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_user_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_ads_id_foreign');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->dropForeign('followers_user_id_foreign');
		});
		Schema::table('followers', function(Blueprint $table) {
			$table->dropForeign('followers_follower_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_user_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_ads_id_foreign');
		});
	}
}