<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FormRow extends Eloquent {

	protected $table = 'form_rows';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('major_number', 'minor_number', 'diminutive_number');
	protected $visible = array('major_number', 'minor_number', 'diminutive_number', 'sort_order');

	public function controlForm()
	{
		return $this->belongsTo('ControlForm');
	}

}