<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FormTableBreak extends Eloquent {

	protected $table = 'form_table_breaks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $visible = array('controlForm', 'formRow');

	public function formRow()
	{
		return $this->belongsTo('FormRow');
	}

	public function controlForm()
	{
		return $this->belongsTo('ControlForm');
	}

}