<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormValuesTable extends Migration {

	public function up()
	{
		Schema::create('form_values', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('value')->nullable();
			$table->smallInteger('row_index')->default('0');
			$table->smallInteger('column_index')->default('0');
			$table->smallInteger('major_index')->default('0');
			$table->bigInteger('form_submission_id')->index();
		});
	}

	public function down()
	{
		Schema::drop('form_values');
	}
}