<?php

namespace Fusionalliance\Controlforms;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FormContainerFormMetaField extends Eloquent {

	protected $table = 'form_container_form_meta_field';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $visible = array('form_container_id');

	public function controlForm()
	{
		return $this->belongsTo('ControlForm');
	}

	public function formContainer()
	{
		return $this->belongsTo('FormContainer');
	}

	public function formMetaField()
	{
		return $this->belongsTo('FormMetaField');
	}

}